VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Object = "{D8590F4A-FB91-11D1-BE52-444553540000}#1.0#0"; "SonarSystem.ocx"
Begin VB.Form frmCollection 
   Caption         =   "SciFish 2000"
   ClientHeight    =   4665
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   6975
   Icon            =   "Collection.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4665
   ScaleWidth      =   6975
   StartUpPosition =   3  'Windows Default
   Begin MSCommLib.MSComm comGps 
      Left            =   1320
      Top             =   0
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin MSComDlg.CommonDialog cdlOpen 
      Left            =   2388
      Top             =   48
      _ExtentX        =   688
      _ExtentY        =   688
      _Version        =   393216
   End
   Begin VB.Timer tmrCursor 
      Enabled         =   0   'False
      Left            =   3720
      Top             =   96
   End
   Begin VB.Timer tmrSonar 
      Enabled         =   0   'False
      Left            =   4452
      Top             =   96
   End
   Begin VB.Timer tmrLayout 
      Enabled         =   0   'False
      Left            =   4080
      Top             =   120
   End
   Begin MSComctlLib.StatusBar StatusBar 
      Align           =   2  'Align Bottom
      Height          =   255
      Left            =   0
      TabIndex        =   3
      Top             =   4410
      Width           =   6975
      _ExtentX        =   12303
      _ExtentY        =   450
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   5
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Bevel           =   2
            Object.Width           =   508
            MinWidth        =   508
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
         EndProperty
         BeginProperty Panel4 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
            Object.Width           =   5080
            MinWidth        =   5080
         EndProperty
         BeginProperty Panel5 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   5080
            MinWidth        =   5080
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.PictureBox pctHiRes 
      Height          =   1968
      Left            =   4704
      ScaleHeight     =   1905
      ScaleWidth      =   2070
      TabIndex        =   2
      Top             =   2388
      Width           =   2124
   End
   Begin VB.PictureBox pctHist 
      BackColor       =   &H00000000&
      Height          =   2148
      Left            =   4680
      ScaleHeight     =   2085
      ScaleWidth      =   2040
      TabIndex        =   1
      Top             =   168
      Width           =   2100
   End
   Begin VB.PictureBox pctLowRes 
      Height          =   4212
      Left            =   48
      ScaleHeight     =   277
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   300
      TabIndex        =   0
      Top             =   156
      Width           =   4560
   End
   Begin SONARSYSTEMLib.SonarSystem SonarOCX 
      Left            =   3360
      Top             =   0
      _Version        =   65536
      _ExtentX        =   1508
      _ExtentY        =   873
      _StockProps     =   0
   End
   Begin VB.Menu mnuSystem 
      Caption         =   "&System"
      Begin VB.Menu mnuPingPause 
         Caption         =   "P&ause Pinging"
      End
      Begin VB.Menu mnuPingResume 
         Caption         =   "R&esume Pinging"
      End
      Begin VB.Menu mnuPingOnce 
         Caption         =   "&Ping Once"
      End
      Begin VB.Menu mnuPingStart 
         Caption         =   "Start &Pinging"
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuPingStop 
         Caption         =   "S&top Pinging"
      End
      Begin VB.Menu mnuspace2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSonarConfiguration 
         Caption         =   "&Sonar Configuration..."
      End
      Begin VB.Menu mnuPlaybackConfiguration 
         Caption         =   "Pla&yback Configuration..."
      End
      Begin VB.Menu mnuPlayback 
         Caption         =   "Playback &Mode"
         Enabled         =   0   'False
         Shortcut        =   ^M
         Visible         =   0   'False
      End
      Begin VB.Menu mnuTrackerOn 
         Caption         =   "Turn Tracker &ON"
         Shortcut        =   ^T
      End
      Begin VB.Menu mnuNewPingLog 
         Caption         =   "New Ping Log..."
      End
      Begin VB.Menu mnuSpace1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuGPS 
         Caption         =   "&GPS Configuration..."
      End
      Begin VB.Menu mnuMaintenance 
         Caption         =   "Maintenance Mode"
         Shortcut        =   ^E
         Visible         =   0   'False
      End
      Begin VB.Menu mnuOneClick 
         Caption         =   "One Click Logging"
         Visible         =   0   'False
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
         Shortcut        =   ^W
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mnuCopy 
         Caption         =   "&Copy"
         Shortcut        =   ^C
      End
      Begin VB.Menu mnuExemplars 
         Caption         =   "E&xemplar Sets..."
      End
      Begin VB.Menu mnuImportClassifier 
         Caption         =   "&Import Classifier..."
      End
      Begin VB.Menu mnuReplica 
         Caption         =   "Import &Replica..."
      End
      Begin VB.Menu mnuspace0526 
         Caption         =   "-"
      End
      Begin VB.Menu mnuPreferences 
         Caption         =   "Preferences..."
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuLowRes 
         Caption         =   "&Low Res Pane"
         Begin VB.Menu mnuLowResSub 
            Caption         =   "LowResSub"
            Index           =   0
         End
      End
      Begin VB.Menu mnuHiRes 
         Caption         =   "&High Res Pane"
         Begin VB.Menu mnuHiResSub 
            Caption         =   "HiResSub"
            Index           =   0
         End
      End
      Begin VB.Menu mnuDistribution 
         Caption         =   "&Distribution Pane"
         Begin VB.Menu mnuDistributionSub 
            Caption         =   "DistributionSub"
            Index           =   0
         End
      End
      Begin VB.Menu mnuAllPanes 
         Caption         =   "&All Panes"
         Begin VB.Menu mnuClearAllPanes 
            Caption         =   "&Clear"
         End
         Begin VB.Menu mnuHidePanes 
            Caption         =   "&Hide"
         End
      End
      Begin VB.Menu mnuWindows 
         Caption         =   "&Windows"
         Begin VB.Menu mnuOscilloscope 
            Caption         =   "&Oscilloscope"
         End
         Begin VB.Menu mnuClassGram 
            Caption         =   "&Class Gram"
            Enabled         =   0   'False
            Visible         =   0   'False
         End
         Begin VB.Menu mnuEnergyGram 
            Caption         =   "&Energy Gram"
            Enabled         =   0   'False
            Visible         =   0   'False
         End
      End
   End
   Begin VB.Menu mnuTracker 
      Caption         =   "&Tracker"
      Visible         =   0   'False
      Begin VB.Menu mnuTrackDisplaySettings 
         Caption         =   "Track &Display Settings..."
         Shortcut        =   {F1}
      End
      Begin VB.Menu mnuTrackerParameters 
         Caption         =   "Tracker &Parameters..."
         Shortcut        =   {F2}
      End
      Begin VB.Menu mnuTrackExport 
         Caption         =   "Track &Export"
         Shortcut        =   {F3}
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Enabled         =   0   'False
   End
   Begin VB.Menu mnuContext 
      Caption         =   "Context"
      Visible         =   0   'False
      Begin VB.Menu mnuContextSub 
         Caption         =   "ContextSub"
         Index           =   0
      End
   End
End
Attribute VB_Name = "frmCollection"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public Enum PingEvents
  peStart
  peStop
  peOnce
  pePause
  peResume
End Enum

Public Enum StatusBarPanels
  sbpStateText = 1
  sbpStateLight = 2
  sbpLogText = 3
  sbpMouseText = 5
  sbpCoordinates = 4
End Enum

Private Enum StatusLights
  slPaused = 103
  slPinging = 101
  slInactive = 102
  slPingingNow = 104
End Enum

Private WithEvents ClassGram As frmEchogram2  ' Free standing window
Attribute ClassGram.VB_VarHelpID = -1
Private WithEvents Distribution As DistributionPlotClass ' Object controlling pane
Attribute Distribution.VB_VarHelpID = -1
Private WithEvents EchogramLowRes As EchoGramClass ' Object controlling pane
Attribute EchogramLowRes.VB_VarHelpID = -1
Private WithEvents EchogramHiRes As EchoGramClass ' Object controlling pane
Attribute EchogramHiRes.VB_VarHelpID = -1
Private WithEvents EnergyGram As frmEchogram2 ' Free standing window
Attribute EnergyGram.VB_VarHelpID = -1
Private WithEvents Gps As GpsClass
Attribute Gps.VB_VarHelpID = -1
Private WithEvents Oscilloscope As frmTSPlot ' Free standing window
Attribute Oscilloscope.VB_VarHelpID = -1
Public WithEvents sonarIF As SonarClass
Attribute sonarIF.VB_VarHelpID = -1

Private distributionFraction As Single
Private panesHidden As Boolean
Private lowResFraction As Single
Private oldWindowState As Integer
Private resizing As Boolean
Private wasMinimized As Boolean

Const className = "frmCollection"

Private Sub AdcpSyncInterface()

  Dim sync As Boolean
  sync = general.propertyList.GetProperty("Norway:useAdcpSync", False)
  If sync Then
    Dim reply As Integer
    reply = MsgBox("Stop using ADCP synchronization?", _
                   vbYesNoCancel + vbQuestion, _
                  "ADCP Synchronization")
    If reply = vbYes Then
      general.propertyList.SetProperty "Norway:useAdcpSync", False
      general.sonarIF.SetEnableSync False
    End If
  Else
    reply = MsgBox("Begin using ADCP synchronization?", _
                   vbYesNoCancel + vbQuestion, _
                  "ADCP Synchronization")
    If reply = vbYes Then
      frmAlertBox.alertBoxShow "Verify sonar operation after entering this mode (Green box should light when transmitting)", _
        abiExclamation, title:="Cautionary Note: Incorrect parameter settings may prevent sonar transmissions", _
                           expireInSeconds:=25

      Dim delay, delayMax As Long
      Dim X As String
      Do
        Do
            delay = general.propertyList.GetProperty("Norway:delay", 1000)
            X = InputBox("What is the min wait time after ADCP ping ensemble start (ms)?", _
                         "ADCP Synchronization", delay)
            If X = "" Then Exit Sub
            If (Not IsNumeric(X)) Then
                MsgBox "Min wait time must be a number", title:="ADCP Synchronization"
                delay = 0
            Else
                delay = CLng(X)
                If Not InRange(10, delay, 65535) Then
                    MsgBox "Min wait time must be a valid millisecond timer interval", _
                        title:="ADCP Synchronization"
                End If
            End If
        Loop Until InRange(10, delay, 65535)
        
        Do
            delayMax = general.propertyList.GetProperty("Norway:delayMax", 1000)
            X = InputBox("What is the max wait time after ADCP ping ensemble start (ms)?", _
                       "ADCP Synchronization", delayMax)
            If X = "" Then Exit Sub
            If (Not IsNumeric(X)) Then
                MsgBox "Max wait time must be a number", title:="ADCP Synchronization"
                delayMax = 0
            Else
                delayMax = CLng(X)
                If Not InRange(10, delayMax, 65535) Then
                    MsgBox "Max wait time must be a valid millisecond timer interval", _
                        title:="ADCP Synchronization"
                End If
            End If
        Loop Until InRange(10, delayMax, 65535)
        
        If delay > delayMax Or delay <= 10 Then
          MsgBox "Invalid delay times (Minimum delay can't exceed Maximum delay)", _
            title:="ADCP Synchronization"
        End If
      Loop Until delay <= delayMax And delay > 10
      general.propertyList.SetProperty "Norway:delay", delay
      general.propertyList.SetProperty "Norway:delayMax", delayMax
      general.propertyList.SetProperty "Norway:useAdcpSync", True
      general.sonarIF.SetEnableSync True, delay, delayMax
    End If
  End If
  
  MenuConfigure
  
End Sub

Private Sub ConfigureMaintenanceMode()
  mnuMaintenance.checked = general.maintenanceMode
  mnuOneClick.visible = general.maintenanceMode
  mnuOneClick.checked = general.propertyList.GetProperty("General:OneClickLogging", False)
  mnuHidePanes.visible = general.maintenanceMode
  mnuWindows.visible = general.maintenanceMode
  mnuReplica.visible = general.maintenanceMode
  mnuExemplars.visible = general.maintenanceMode
  mnuImportClassifier.visible = general.maintenanceMode
  mnuPlaybackConfiguration.visible = general.maintenanceMode
  mnuPlayback.visible = general.maintenanceMode
  If mnuPlayback.visible Then
    mnuPlayback.checked = general.sonarIF.isPlayback
    mnuPlaybackConfiguration.enabled = mnuPlayback.checked
  Else
    general.sonarIF.SetPlaybackMode False
    general.propertyList.SetProperty "General:PlaybackMode", False
  End If
  
  mnuExemplars.enabled = Not general.sonarIF.IsPinging
  mnuImportClassifier.enabled = Not general.sonarIF.IsPinging
  mnuReplica.enabled = Not general.sonarIF.IsPinging
  
End Sub
Private Sub MenuConfigure()

  Dim statusText As String
  Dim statusPictureID As Integer

  ConfigureMaintenanceMode
  
  With general.sonarIF
    
    If .IsPinging Then
    
      Dim logging As LoggingTypes
      logging = general.propertyList.GetProperty("General:Logging", ltNone)
      If logging = ltNone Then
        StatusBar.Panels(sbpLogText).visible = False
      Else
        StatusBar.Panels(sbpLogText).visible = True
        StatusBar.Panels(sbpLogText).text = _
          "Logging: " & IIf((logging And ltEchoes) <> 0, "echoes", "") & _
          IIf(logging = ltPings + ltEchoes, "&", "") & IIf((logging And ltPings) <> 0, "pings", "")
      End If
      mnuPingStop.visible = True
      mnuPingStart.visible = False
      mnuPlayback.enabled = False
      mnuNewPingLog.enabled = False
      
      If .IsManualPing Then
        mnuPingResume.visible = False
        mnuPingPause.visible = False
        mnuPingOnce.visible = True
        statusPictureID = slPaused ' Yellow Light
        statusText = "Manual " & IIf(general.sonarIF.isPlayback, "Playback", "Ping")
      Else
        mnuPingOnce.visible = False
        If .IsPaused Then
          statusPictureID = slPaused ' Yellow light
          statusText = "Paused"
          mnuPingResume.visible = general.maintenanceMode
          mnuPingPause.visible = False
        Else
          statusPictureID = slPinging ' Green light
          statusText = IIf(general.sonarIF.isPlayback, "Playing Back", "Pinging")
          mnuPingResume.visible = False
          mnuPingPause.visible = general.maintenanceMode
        End If
      End If
    
    Else  ' Not pinging
    
      StatusBar.Panels(sbpLogText).visible = False
      statusPictureID = slInactive ' Clear Light
      statusText = "Inactive"
      mnuPingOnce.visible = False
      mnuPingPause.visible = False
      mnuPingResume.visible = False
      mnuPingStop.visible = False
      mnuPingStart.visible = True
      mnuPlayback.enabled = general.maintenanceMode
      mnuNewPingLog.enabled = True

    End If
    
  End With
    
  StatusBar.Panels(sbpStateLight).picture = LoadResPicture(statusPictureID, vbResIcon)
  StatusBar.Panels(sbpStateText).text = statusText

  '  Fix up the form caption

  caption = "SciFish 2000     "
  If general.sonarIF.isPlayback Then
    Dim playbackName As String
    playbackName = general.sonarIF.GetPingSeriesName()
    If playbackName = "" Then playbackName = general.sonarIF.GetPingSeriesID()
    If playbackName = "" Then playbackName = "* None *"
    caption = caption & " [playback: " & playbackName & " ]"
  Else
    Dim configName As String
    configName = general.sonarIF.GetSonarConfiguration().GetName()
    If configName = "" Then
      configName = general.sonarIF.GetSonarConfiguration().GetValue("SonarConfigurationID")
    End If
    If configName = "" Then configName = "* None *"
    caption = caption & " [configuration: " & configName
    If logging <> ltNone Then
      caption = caption & "; logging to " & general.pingDB.GetFile()
    End If
    caption = caption & " ]"
  End If
  caption = caption & IIf(general.propertyList.GetProperty("General:SonarIsRdi2", False), "         <2>", "         <1>")
  If general.maintenanceMode Then
    caption = caption & "   *MAINTENANCE MODE*"
  Else
  End If
  If general.sonarIF.isUsingAdcpSync() Then caption = caption & " SYNC "
  
  trackerMnuConfig ' configures tracker mnu items REB 2002.06.18
  
End Sub

Public Sub PingArrived(ByVal pingNumber As Long)

  If general.sonarIF.IsManualPing Then
    StatusBar.Panels(sbpStateLight).picture = LoadResPicture(slPaused, vbResIcon)
  End If

End Sub

Private Sub PingController(pingEvent As PingEvents)

  MousePointer = vbHourglass
  Select Case pingEvent
  
    Case peStart
      general.sonarIF.PingingStart
      
    Case peStop
      general.sonarIF.PingingStop
      
    Case peOnce
      StatusBar.Panels(sbpStateLight).picture = LoadResPicture(slPinging, vbResIcon)
      general.sonarIF.PingingPingOnce
   
    Case pePause
      general.sonarIF.PingingPause
      
    Case peResume
      general.sonarIF.PingingResume
      
    Case Else
      Debug.Assert (False)
      
  End Select
  
  MousePointer = vbDefault
  MenuConfigure

End Sub

Public Sub SetCaption(Optional value As String = "SciFish 2000")

  caption = value

End Sub

Public Sub setGps()

  Set Gps = general.Gps

End Sub
Private Sub SetupMenu(theObject As Object, theMenu As Object)

  Dim objectMenu As Scripting.Dictionary
  Set objectMenu = theObject.GetMenu()
  Dim i As Integer
  Dim startCount As Integer
  Dim objectMenuItems() As Variant
  objectMenuItems = objectMenu.Items
  startCount = theMenu.count
  For i = 0 To objectMenu.count - 1
    If i >= startCount Then Load theMenu(i)
    With theMenu(i)
      .caption = objectMenuItems(i).item("caption")
      .checked = objectMenuItems(i).item("checked")
      .enabled = objectMenuItems(i).item("enabled")
      .tag = objectMenuItems(i).item("tag")
      If i <> 0 Then .visible = objectMenuItems(i).item("visible")
    End With
  Next i

End Sub

Private Sub ClassGram_Terminate()

  Set ClassGram = Nothing

End Sub

Private Sub Distribution_ContextMenuRequest(ByVal X As Long, ByVal Y As Long)

  Dim needResume As Boolean
  needResume = False
  
  If sonarIF.IsPinging And Not sonarIF.IsPaused Then
    sonarIF.PingingPause
    needResume = True
  End If
  
  SetupMenu Distribution, mnuDistributionSub
  Me.PopupMenu mnuDistribution, , pctHist.Left + X, pctHist.Top + Y
  
  If needResume Then sonarIF.PingingResume

End Sub

Private Sub Distribution_KeyDown(KeyCode As Integer, Shift As Integer)
  Form_KeyDown KeyCode, Shift
End Sub

Private Sub Distribution_StatusBar(ByVal statusText As String)

  StatusBar.Panels(sbpMouseText).text = statusText

End Sub

Private Sub Distribution_DimensionChange()

    EchogramHiRes.Clear
    
End Sub

Private Sub EchogramHiRes_ContextMenuRequest(ByVal X As Long, ByVal Y As Long)
  
  Dim needResume As Boolean
  needResume = False
  
  If sonarIF.IsPinging And Not sonarIF.IsPaused Then
    sonarIF.PingingPause
    needResume = True
  End If
     
  SetupMenu EchogramHiRes, mnuHiResSub
  Me.PopupMenu mnuHiRes, , pctHiRes.Left + X, pctHiRes.Top + Y
  
  If needResume Then sonarIF.PingingResume

End Sub

Private Sub EchogramHiRes_DimensionChange(ByVal rangeMin As Single, _
                                          ByVal rangeMax As Single, _
                                          ByVal nPointsX As Long, _
                                          ByVal changeType As Boolean, _
                                          ByVal changeToClass As Boolean)

  If changeType Then
    Dim plotType As DistributionPlotType
    Debug.Assert (Not IsMissing(changeToClass))
    plotType = IIf(changeToClass, dptClass, dptTargetStrength)
    Distribution.PlotSetup "DistributionRT", pctHist, plotType, _
                            rangeMin, rangeMax, nPointsX
  Else
    Distribution.Clear
    Distribution.PlotLayout rangeMin, rangeMax, nPointsX
  End If

End Sub

Private Sub EchogramHiRes_StatusBar(ByVal statusText As String)
  
  StatusBar.Panels(sbpMouseText).text = statusText

End Sub

Private Sub EchogramHiRes_KeyDown(KeyCode As Integer, Shift As Integer)
  Form_KeyDown KeyCode, Shift
End Sub

Private Sub EchogramLowRes_ContextMenuRequest(ByVal X As Long, ByVal Y As Long)

  Dim needResume As Boolean
  needResume = False
  
  If sonarIF.IsPinging And Not sonarIF.IsPaused Then
    sonarIF.PingingPause
    needResume = True
  End If
  
  SetupMenu EchogramLowRes, mnuLowResSub
  Me.PopupMenu mnuLowRes, , pctLowRes.Left + X, pctLowRes.Top + Y
  
  If needResume Then sonarIF.PingingResume
  
End Sub

Private Sub EchogramLowRes_StatusBar(ByVal statusText As String)

  StatusBar.Panels(sbpMouseText).text = statusText

End Sub

Private Sub EchogramLowRes_KeyDown(KeyCode As Integer, Shift As Integer)

  Form_KeyDown KeyCode, Shift

End Sub

Private Sub EnergyGram_Terminate()

  Set EnergyGram = Nothing

End Sub

Private Sub Form_Activate()

  If general.maintenanceMode Then mnuMaintenance.visible = True
  MenuConfigure

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)

  Dim altbutton As Boolean
  Dim controlbutton As Boolean
  Dim keyHandled As Boolean
  Dim shiftbutton As Boolean

  shiftbutton = (Shift And vbShiftMask) <> 0
  controlbutton = (Shift And vbCtrlMask) <> 0
  altbutton = (Shift And vbAltMask) <> 0
  keyHandled = False
  
  Select Case KeyCode
    Case vbKeyF1
      If controlbutton Then
        Dim magicKeys As MagicKeyDisplayClass
        Set magicKeys = New MagicKeyDisplayClass
        
        With magicKeys
          .addKey vbKeyP, "cs", "Ping once"
          .display "Magic Keys for SciFish2000 Window"
        End With
        Set magicKeys = Nothing
        keyHandled = True
      End If
    
    Case vbKeyP
    
      If shiftbutton And controlbutton Then
        If general.sonarIF.IsPinging Then
          If general.sonarIF.IsManualPing Then
            PingController peOnce
          Else
            If general.sonarIF.IsPaused Then
              PingController peResume
            Else
              PingController pePause
            End If
          End If
        Else
          PingController peStart
        End If
        MenuConfigure
        keyHandled = True
      End If
      
      
    Case vbKeyE
      If shiftbutton And controlbutton And altbutton Then
        general.maintenanceMode = True
        general.propertyList.SetProperty "General:maintenanceMode", general.maintenanceMode
        mnuMaintenance.visible = True
        MenuConfigure
        Beep
        Sleep 300
        Beep
        Sleep 100
        Beep
      End If
             
    Case vbKeyS
      If shiftbutton And controlbutton And altbutton Then
        AdcpSyncInterface
      End If
    
       
    Case vbKeyControl, vbKeyShift, 18
      keyHandled = True ' don't beep at these
  
  End Select
  
  'If Not keyHandled Then Beep

End Sub

Private Sub Form_Load()

  lowResFraction = 0.68
  distributionFraction = 0.5
  resizing = False
  wasMinimized = False
  
  Dim mapName As String
  mapName = general.propertyList.GetProperty("EnergyGramLowRes:ColorMapName", "_StandardEnergy")
  Dim colormap As ColorMapClass
  Set colormap = New ColorMapClass
  colormap.ReadFromDB mapName, general.parametersDb
  
  Set EchogramLowRes = New EchoGramClass
  EchogramLowRes.SetupEchoGram "EnergyGramLowRes", estRealtime, egtEnergy, _
                               "LowRes Gram", pctLowRes, colormap:=colormap
  SetupMenu EchogramLowRes, mnuLowResSub
  
  Set EchogramHiRes = New EchoGramClass
  EchogramHiRes.SetupEchoGram "EnergyGramHiRes", estRealtime, egtEnergy, _
                               "HiRes Gram", pctHiRes, colormap:=colormap, _
                               scrollOneColumn:=True
  SetupMenu EchogramHiRes, mnuHiResSub
  
  Set Distribution = New DistributionPlotClass
  Distribution.PlotSetup "DistributionRT", pctHist, dptTargetStrength, _
                         20, 30, 5, colormap:=colormap
  SetupMenu Distribution, mnuDistributionSub
                         
  general.sonarIF.addPingListener Me, 0
  
  
  mnuHidePanes.checked = False
  panesHidden = False
  MenuConfigure

End Sub

Private Sub Form_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

  If MousePointer = vbSizeNS Or MousePointer = vbSizeWE Then
    tmrCursor.enabled = False
    resizing = True
  End If

End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

  If resizing Then
    If MousePointer = vbSizeNS Then
      distributionFraction = mind(maxd(Y / Me.ScaleHeight, 0.1), 0.9)
    Else
      lowResFraction = mind(maxd(X / Me.ScaleWidth, 0.1), 0.9)
    End If
    Form_Resize
    tmrCursor.enabled = False
    tmrCursor.interval = 1000
    tmrCursor.enabled = True
  ElseIf X >= pctLowRes.width + pctLowRes.Left And X <= pctHist.Left Then
    MousePointer = vbSizeWE
    tmrCursor.enabled = False
    tmrCursor.interval = 1000
    tmrCursor.enabled = True
  ElseIf X >= pctHist And Y >= pctHist.Top + pctHist.height And Y <= pctHiRes.Top Then
    MousePointer = vbSizeNS
    tmrCursor.enabled = False
    tmrCursor.interval = 1000
    tmrCursor.enabled = True
  Else
    MousePointer = vbDefault
    resizing = False
  End If

End Sub

Private Sub Form_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

  If resizing Then
    MousePointer = vbDefault
    resizing = False
  End If

End Sub

Private Sub Form_Resize()
  
  If Me.WindowState = 1 Then     ' Now minimized, so do not resize.
    wasMinimized = True
    Exit Sub
  End If
  
  '  If restoring from minimized to the previous window state (maximized or normal) then there
  '  is no need to change window dimensions and refresh the panes.
  
  If wasMinimized And oldWindowState = Me.WindowState Then Exit Sub
  wasMinimized = False
  oldWindowState = Me.WindowState
  
  If panesHidden Then Exit Sub
  
  tmrLayout.enabled = False
  tmrLayout.interval = 1000
  tmrLayout.enabled = True
  
  pctLowRes.Left = 0
  pctLowRes.Top = 0
  pctLowRes.width = Me.ScaleWidth * lowResFraction - 3
  pctLowRes.height = Me.ScaleHeight - StatusBar.height
  
  pctHist.Left = pctLowRes.Left + pctLowRes.width + 3
  pctHist.Top = 0
  pctHist.width = (1 - lowResFraction) * Me.ScaleWidth
  pctHist.height = pctLowRes.height * distributionFraction - 3
  
  pctHiRes.Left = pctHist.Left
  pctHiRes.Top = pctHist.Top + pctHist.height + 3
  pctHiRes.width = pctHist.width
  pctHiRes.height = (1 - distributionFraction) * pctLowRes.height
  
End Sub

Private Sub Form_Unload(Cancel As Integer)

  On Error GoTo oops

  If general.sonarIF.IsPinging Then
    general.sonarIF.PingingStop
  End If

  tmrLayout.enabled = False
  tmrSonar.enabled = False

  If Not EchogramLowRes Is Nothing Then
    EchogramLowRes.TeardownGram
    Set EchogramLowRes = Nothing
  End If
  
  If Not EchogramHiRes Is Nothing Then
    EchogramHiRes.TeardownGram
    Set EchogramHiRes = Nothing
  End If
  
  If Not Distribution Is Nothing Then
    Distribution.TeardownPlot
    Set Distribution = Nothing
  End If
  
  general.propertyList.SetProperty "General:Maximized", _
                                   Me.WindowState = vbMaximized
                                   
  '  Unload all active (nonmodal) forms, so program will exit
  '  --------------------------------------------------------

  ' Make as static copy of the current forms
  
  Dim i As Integer
  Dim n As Integer
  n = Forms.count
  ReDim myforms(0 To n - 1) As Form
  For i = 0 To n - 1
    Set myforms(i) = Forms(i)
  Next i
  
  ' Unload all the forms
  
  For i = 0 To n - 1
    On Error GoTo ignore
    Unload myforms(i)
ignore:
    Set myforms(i) = Nothing
  Next i
  On Error GoTo oops
  
  Dim reply As Integer
  reply = MsgBox("Compact databases?", vbYesNo, "SciFish2000 Shutdown")
  If reply = vbYes Then
  
    Me.Hide
    Load frmSplash
    frmSplash.lblNotice.caption = "Compacting Databases..."
    frmSplash.Show
    DoEvents
  
    Dim devLen As Long
    Dim devName As String
    Dim parLen As Long
    Dim parName As String
    Dim pingLen As Long
    Dim pingName As String
    
    pingName = general.propertyList.GetProperty("General:PingDBFile", "")
    pingLen = general.propertyList.GetProperty("General:PingDBLen", 0)
    devName = general.propertyList.GetProperty("General:developmentDBFile", "")
    devLen = general.propertyList.GetProperty("General:developmentDBLen", 0)
    parName = general.propertyList.GetProperty("General:parametersDBFile", "")
    parLen = general.propertyList.GetProperty("General:parametersDBLen", 0)
  
    general.parametersDb.dbClose
    If general.parametersDb.GetFile <> parName Or _
       FileLen(general.parametersDb.GetFile) > parLen * 1.5 Then
      general.parametersDb.Compact
      parLen = FileLen(general.parametersDb.GetFile)
    Else
      parLen = 0
    End If
    
    If general.pingDB.GetFile <> pingName Or _
       FileLen(general.pingDB.GetFile) > pingLen * 1.5 Then
      general.pingDB.Execute "delete * from echo"
      general.pingDB.dbClose
      pingLen = FileLen(general.pingDB.GetFile)
      general.pingDB.Compact
    Else
      pingLen = 0
    End If
    
    If general.developmentDB.GetFile <> devName Or _
       FileLen(general.developmentDB.GetFile) > devLen * 1.5 Then
      general.developmentDB.Execute "delete * from tmpping"
      general.developmentDB.Execute "delete * from tmppingseries"
      general.developmentDB.Execute "delete * from tmpexemplar"
      general.developmentDB.dbClose
      general.developmentDB.Compact
      devLen = FileLen(general.developmentDB.GetFile)
    Else
      devLen = 0
    End If
    
    If parLen > 0 Or devLen > 0 Or pingLen > 0 Then
    
      general.parametersDb.dbOpen
      If pingLen > 0 Then
        general.propertyList.SetProperty "General:PingDBFile", general.pingDB.GetFile
        general.propertyList.SetProperty "General:PingDBLen", pingLen
      End If
      If devLen > 0 Then
        general.propertyList.SetProperty "General:developmentDBFile", general.developmentDB.GetFile
        general.propertyList.SetProperty "General:developmentDBLen", devLen
      End If
      If parLen > 0 Then
        general.propertyList.SetProperty "General:parametersDBFile", general.parametersDb.GetFile
        general.propertyList.SetProperty "General:parametersDBLen", parLen
      End If
    
    End If

  End If
  
  frmSplash.Hide
  Unload frmSplash
  Exit Sub
  
oops:

  ErrorBox "Error during unload or compaction: "

End Sub

Private Sub Gps_PositionUpdate()

  Dim lat As Double
  Dim lon As Double
  Dim s As String
  Dim theTime As Date
  
  If Gps.GetGpsState() = gpsActive Then
    Gps.GetGPSLatLonTime lat, lon, theTime
    s = LatLonDoubleToString(lat, True) & " " & LatLonDoubleToString(lon, False) & _
        " " & Format(theTime, "Hh:Nn:Ss") & " Z "
  Else
    s = "No GPS data"
  End If
    StatusBar.Panels(sbpCoordinates).text = s

End Sub

Private Sub mnuClassGram_Click()

  If ClassGram Is Nothing Then _
    Set ClassGram = New frmEchogram2

  ClassGram.ShowEchogram "ClassGram", egtClass, estRealtime, "Class Gram"

End Sub

Private Sub mnuClearAllPanes_Click()

  EchogramHiRes.ClearGram
  EchogramLowRes.ClearGram
  Distribution.Clear

End Sub

Private Sub mnuCopy_Click()
'DFL KB#41
  
  Clipboard.Clear

  Dim theHeight As Long
  Dim theWidth As Long

  theWidth = Me.width / Screen.TwipsPerPixelX
  theHeight = Me.height / Screen.TwipsPerPixelY
  Clipboard.SetData CaptureWindow(Me.hWnd, False, 0, 0, theWidth, theHeight)

End Sub

Private Sub mnuDistribution_Click()

  SetupMenu Distribution, mnuDistributionSub

End Sub

Private Sub mnuDistributionSub_Click(index As Integer)
  
  MousePointer = vbHourglass
  Distribution.MenuAction mnuDistributionSub(index).tag
  MousePointer = vbDefault

End Sub

Private Sub mnuEnergyGram_Click()

  If EnergyGram Is Nothing Then _
    Set EnergyGram = New frmEchogram2

  EnergyGram.ShowEchogram "EnergyGram", egtEnergy, estRealtime, "Energy Gram"

End Sub

Private Sub mnuExemplars_Click()

  Dim exemplarSetEditor As frmExemplarSetEditor
  Set exemplarSetEditor = New frmExemplarSetEditor
  exemplarSetEditor.Show

End Sub


Private Sub mnuExit_Click()

  Dim reply As Integer
  reply = MsgBox("Terminate the SciFish2000 application?", vbQuestion + vbYesNo, _
                  "SciFish2000")
                  
  If reply = vbYes Then Unload Me

End Sub

Private Sub mnuMaintenance_Click()

  mnuMaintenance.checked = Not mnuMaintenance.checked
  general.maintenanceMode = mnuMaintenance.checked
  general.propertyList.SetProperty "General:maintenanceMode", general.maintenanceMode
  MenuConfigure
  
End Sub


Private Sub mnuGPS_Click()

  frmGps.ManageGps

End Sub

Private Sub mnuHidePanes_Click()

  Dim hideIt As Boolean
  hideIt = Not mnuHidePanes.checked
  mnuHidePanes.checked = hideIt
  
  If hideIt Then
  
    Dim newHeight As Long
    Dim newWidth As Long
    newHeight = GetFormsReservedHeight() + StatusBar.height * Screen.TwipsPerPixelY
    pctHiRes.visible = False
    pctLowRes.visible = False
    pctHist.visible = False
    newWidth = Me.width
    panesHidden = True
    Me.WindowState = vbNormal
    Me.Move 0, 0, newWidth, newHeight
    
  Else
    
    panesHidden = False
    pctHiRes.visible = True
    pctLowRes.visible = True
    pctHist.visible = True
  
    Me.WindowState = vbMaximized
  
  End If

End Sub

Private Sub mnuHiRes_Click()
  
  SetupMenu EchogramHiRes, mnuHiResSub

End Sub

Private Sub mnuHiResSub_Click(index As Integer)

  MousePointer = vbHourglass
  EchogramHiRes.MenuAction mnuHiResSub(index).tag
  MousePointer = vbDefault

End Sub

Private Sub mnuImportClassifier_Click()
  
  frmNetImporter.NetImport

End Sub

Private Sub mnuLowRes_Click()

  SetupMenu EchogramLowRes, mnuLowResSub
 
End Sub

Private Sub mnuLowResSub_Click(index As Integer)

  MousePointer = vbHourglass
  EchogramLowRes.MenuAction mnuLowResSub(index).tag
  MousePointer = vbDefault
  
End Sub

Private Sub mnuNewPingLog_Click()

  ChangePingDatabase True, cdlOpen

End Sub

Private Sub mnuOneClick_Click()

  mnuOneClick.checked = Not mnuOneClick.checked
  general.propertyList.SetProperty "General:OneClickLogging", mnuOneClick.checked

End Sub

Private Sub mnuOscilloscope_Click()

  If Oscilloscope Is Nothing Then
    Set Oscilloscope = New frmTSPlot
  End If
  Oscilloscope.Show

End Sub

Private Sub mnuPingOnce_Click()

    PingController peOnce
    
End Sub

Private Sub mnuPingPause_Click()
  
  PingController pePause
  trackerMnuConfig ' configures tracker mnu items
  
End Sub

Private Sub mnuPingResume_Click()

  PingController peResume
  trackerMnuConfig ' configures tracker mnu items REB 2002.06.18
  
End Sub

Private Sub mnuPingStart_Click()

  PingController peStart
  
End Sub

Private Sub mnuPingStop_Click()

  PingController peStop
  trackerMnuConfig ' configures tracker mnu items
  
End Sub

Private Sub mnuPlayback_Click()

  Debug.Assert (Not general.sonarIF.IsPinging)
  
  mnuPlayback.checked = Not mnuPlayback.checked
  
  general.sonarIF.SetPlaybackMode mnuPlayback.checked
  mnuPlaybackConfiguration.enabled = mnuPlayback.checked
  
  general.propertyList.SetProperty "General:PlaybackMode", mnuPlayback.checked

  MenuConfigure
  
  If mnuPlayback.checked Then mnuPlaybackConfiguration_Click
  
  trackerMnuConfig ' configures tracker mnu items REB 2002.06.18

End Sub

Private Sub mnuPlaybackConfiguration_Click()

  frmPlaybackParameters.GetPlaybackInfo
  MenuConfigure

End Sub

Private Sub mnuPreferences_Click()

  frmPreferences.Show 1
  EchogramHiRes.changeRangeUnits general.propertyList.GetProperty("General:RangeUnits", ruMeters)
  EchogramLowRes.changeRangeUnits general.propertyList.GetProperty("General:RangeUnits", ruMeters)

End Sub

Private Sub mnuReplica_Click()

  frmReplica.ImportReplica

End Sub

Private Sub mnuSonarConfiguration_Click()

  frmSonarConfiguration.Execute general.maintenanceMode, ReadOnly:=general.sonarIF.IsPinging

End Sub

Private Sub mnuTrackDisplaySettings_Click()

  On Error GoTo oops:
  
  frmTrackDisplaySettings.Setup EchogramLowRes, EchogramHiRes, Distribution
  frmTrackDisplaySettings.Show 1
  trackerMnuConfig
  
  Exit Sub
  
oops:
  ErrorBox
 
End Sub

Private Sub mnuTrackerOn_Click()

  On Error GoTo oops:
  
  general.propertyList.SetProperty "General:Tracker_Active", Not mnuTrackerOn.checked
  mnuTrackerOn.checked = Not mnuTrackerOn.checked
  trackerMnuConfig        ' Updates menu item properties
  
  If mnuTrackerOn.checked Then
    LastUsedTrackerDisplaySettings
    LastUsedTrackerParameter
    With general.sonarIF.trx
      .Set_mHRP EchogramHiRes
      .Set_mLRP EchogramLowRes
      .Set_mDP Distribution
      .Set_mCollect Me
    End With
  End If
  
  Exit Sub
  
oops:
  ErrorBox
  general.propertyList.SetProperty "General:Tracker_Active", vbUnchecked
  mnuTrackerOn.checked = vbUnchecked
  
End Sub

Private Sub mnuTrackerParameters_Click() ' Opens form for tracker parameters

  On Error GoTo oops:
  
  frmTrackerParameters.SetupForm
  trackerMnuConfig
    
  Exit Sub
  
oops:
  ErrorBox

End Sub

Private Sub mnuTrackExport_Click() ' Opens form TrackExport

  On Error GoTo oops:
  
  Load frmTrackExport
  trackerMnuConfig
      
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub Oscilloscope_Terminate()
    
  Set Oscilloscope = Nothing

End Sub
 
Private Sub SonarIF_EndOfPingSeries()

  MenuConfigure

End Sub

Private Sub sonarIF_PingReceived()

  StatusBar.Panels(sbpStateLight).picture = LoadResPicture(slPinging, vbResIcon)
  If sonarIF.getNPingsLost() <> 0 Then
    Dim s As String
    Dim i As Integer
    s = StatusBar.Panels(sbpStateText).text
    i = InStr(1, s, "(")
    If i = 0 Then i = Len(s) + 1
    StatusBar.Panels(sbpStateText).text = Left(s, i - 1) & "(" & sonarIF.getNPingsLost() & ")"
  End If

End Sub

Private Sub sonarIF_PingRequested()

  StatusBar.Panels(sbpStateLight).picture = LoadResPicture(slPingingNow, vbResIcon)

End Sub


Private Sub tmrCursor_Timer()

  tmrCursor.enabled = False
  If MousePointer = vbSizeWE Or MousePointer = vbSizeNS Then
    MousePointer = vbDefault
    resizing = False
  End If

End Sub

Private Sub tmrLayout_Timer()

  ' The timer will trip a while after the last resize on the form.
  ' Ask the graphics objects to refresh themselves.
  
  tmrLayout.enabled = False
  If EchogramLowRes Is Nothing Or EchogramHiRes Is Nothing Then Exit Sub
  EchogramLowRes.LayoutGram
  EchogramHiRes.LayoutGram

End Sub

Public Sub trackerMnuConfig() ' Configures properties of menu items needed for tracker functionality
  
  
  On Error GoTo oops:
  MyStoredError.Clear
  
  Dim trackingOn  As Boolean
  Dim isPlayingBack  As Boolean
  Dim inMaintenanceMode As Boolean
  Dim nowPinging As Boolean
  Dim nowPaused As Boolean
  
  ' Gather all of the information needed
  trackingOn = general.propertyList.GetProperty("General:Tracker_Active", False)
  isPlayingBack = general.propertyList.GetProperty("General:PlaybackMode", False)
  inMaintenanceMode = general.propertyList.GetProperty("General:maintenanceMode", False)
  nowPinging = general.sonarIF.IsPinging
  nowPaused = general.sonarIF.IsPaused
  
reentry:
  ' configure System |Turn Tracker ON (OFF)
  mnuTrackerOn.checked = trackingOn
  mnuTrackerOn.caption = "&Turn Tracker " & IIf(trackingOn, "OFF", "ON")
  
  ' configure Tracker Menu
  mnuTracker.visible = trackingOn
  
  ' configure Tracker | Tracker Display Configuration
  mnuTrackDisplaySettings.enabled = (trackingOn And (Not (nowPinging And (Not (nowPaused)))))
  
  ' configure Tracker | Track Export
  mnuTrackExport.enabled = (trackingOn And (Not nowPinging))
  
  ' configure Tracker |mnuTrackerParameters
  mnuTrackerParameters.enabled = (trackingOn And (Not nowPinging))
  
  
  If Not MyStoredError.IsClear Then ErrorBox
  
  Exit Sub
 
oops:
  Debug.Assert (False)
  StoreError
  On Error GoTo oops2:
  trackingOn = False
  Resume reentry
  
  Exit Sub
  
oops2:
  Resume Next
  
End Sub

Private Sub LastUsedTrackerDisplaySettings()  ' gets the last used Tracker Display configuration
  
  On Error GoTo oops:
  Dim optDP As Integer
  
  With general.propertyList
    ' in case the entries are missing fromt he prop. table
    .SetProperty "Tracker_Display:ShowDP", .GetProperty("Tracker_Display:ShowLRP", vbUnchecked)
    .SetProperty "Tracker_Display:ShowDP", .GetProperty("Tracker_Display:ShowHRP", vbUnchecked)
    .SetProperty "Tracker_Display:ShowDP", .GetProperty("Tracker_Display:ShowDP", 0)
    
    ' dp
    optDP = .GetProperty("Tracker_Display:ShowDP", 0)
    Distribution.SetTrackingOptions optDP
    
    EchogramLowRes.Set_mShowTracks (.GetProperty("Tracker_Display:ShowLRP", vbUnchecked) = vbChecked)
    EchogramHiRes.Set_mShowTracks (.GetProperty("Tracker_Display:ShowHRP", vbUnchecked) = vbChecked)
    
  End With
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub LastUsedTrackerParameter() ' gets the last used Tracker Parameter configuration
  
  Dim LastUsedProfile As String
  
  LastUsedProfile = general.propertyList.GetProperty("General:Tracker_Parameters", "default")
reentry:
  If Not general.trackerParameter.ReadFromDB(name:=LastUsedProfile) Then _
    Err.Raise LOAD_ERROR, className & ".LastUsedTrackerParameter", MyStoredError.DescriptionOfError(LOAD_ERROR)
  
  Exit Sub
  
oops:
  Debug.Assert (False)
  StoreError
  On Error GoTo oops2
  ErrorBox
  LastUsedProfile = "default"
  Resume reentry
  Exit Sub
  
oops2:
  Debug.Assert (False)
  StoreError
  MyStoredError.Raise
  
  
End Sub
